#!BPY

"""
Name: 'DPI calculator'
Blender: 248
Group: 'System'
Tooltip: 'calculate dpi thingys'
"""
# --------------------------------------------------------------------------
# ***** BEGIN GPL LICENSE BLOCK *****
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------
import Blender
from Blender import *
from Blender.Scene import Render

units = ['cm', 'mm', 'inches']
factors = [2.54, 25.4, 1]

scn = Scene.GetCurrent()
rdr = scn.getRenderingContext()

#factors = {'cm': 2.54, 'mm': 25.4, 'inches': 1}


def main():
	
	unit = Draw.PupMenu('unit %t|cm|mm|inch')
	if unit == -1: return
	
	dpi = Draw.PupIntInput('dpi: ', 300, 72, 600)
	if dpi == None: return

	sizeX = Draw.PupIntInput('sizeX (in '+units[unit-1]+'): ', 10, 0, 10000)
	if sizeX == None: return
	
	sizeY = Draw.PupIntInput('sizeY (in '+units[unit-1]+'): ', 10, 0, 10000)
	if sizeY == None: return
	
	confirm = Draw.PupMenu('ok? %t|unit: '+units[unit-1]+'|'+str(dpi)+' dpi|x: '+str(sizeX)+'|y: '+str(sizeY)+'|------|convert!')
	if confirm != -1:
		rdr.imageSizeX(int((sizeX /  factors[unit-1] ) * dpi))
		rdr.imageSizeY(int((sizeY /  factors[unit-1] ) * dpi))

	
main()